/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.data.recipe.builder;

import com.farmersrespite.data.builder.KettleRecipeBuilder;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import plus.dragons.createcentralkitchen.foundation.data.recipe.builder.ConditionedRecipeBuilder;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConditionedKettleRecipeBuilder
implements ConditionedRecipeBuilder<ConditionedKettleRecipeBuilder> {
    private final ResourceLocation id;
    private Item result;
    private int count = 1;
    private int duration = 2400;
    private float experience = 0.35f;
    private Item container = null;
    private boolean needWater = false;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    public ConditionedKettleRecipeBuilder(ResourceLocation id) {
        this.id = id;
    }

    public ConditionedKettleRecipeBuilder require(TagKey<Item> tagIn) {
        return this.require(Ingredient.m_204132_(tagIn));
    }

    public ConditionedKettleRecipeBuilder require(ItemLike itemIn) {
        return this.require(itemIn, 1);
    }

    public ConditionedKettleRecipeBuilder require(ItemLike itemIn, int count) {
        for (int i = 0; i < count; ++i) {
            this.require(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
        }
        return this;
    }

    public ConditionedKettleRecipeBuilder require(Ingredient ingredientIn) {
        return this.require(ingredientIn, 1);
    }

    public ConditionedKettleRecipeBuilder require(Ingredient ingredientIn, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public ConditionedKettleRecipeBuilder duration(int ticks) {
        this.duration = ticks;
        return this;
    }

    public ConditionedKettleRecipeBuilder experience(float experience) {
        this.experience = experience;
        return this;
    }

    public ConditionedKettleRecipeBuilder experience(double experience) {
        this.experience = (float)experience;
        return this;
    }

    public ConditionedKettleRecipeBuilder container(@Nullable Item container) {
        this.container = container;
        return this;
    }

    public ConditionedKettleRecipeBuilder needWater() {
        this.needWater = true;
        return this;
    }

    public ConditionedKettleRecipeBuilder output(ItemLike item, int count) {
        this.result = item.m_5456_();
        this.count = count;
        return this;
    }

    public ConditionedKettleRecipeBuilder output(ItemLike item) {
        return this.output(item, 1);
    }

    @Override
    public ConditionedKettleRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, this.id);
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        id = new ResourceLocation(id.m_135827_(), "brewing/" + id.m_135815_());
        this.ensureValid(id);
        consumer.accept((FinishedRecipe)new Result(id, this.result, this.count, this.ingredients, this.duration, this.experience, this.needWater, this.container, this.conditions));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.result == null) {
            throw new IllegalStateException("No result is defined for kettle brewing recipe " + id + "!");
        }
    }

    public static class Result
    extends KettleRecipeBuilder.Result {
        private final List<ICondition> conditions;

        public Result(ResourceLocation id, Item result, int count, List<Ingredient> ingredient, int duration, float experience, boolean needWater, Item container, List<ICondition> conditions) {
            super(id, result, count, ingredient, duration, experience, needWater, container);
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            if (!this.conditions.isEmpty()) {
                JsonArray conds = new JsonArray();
                this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
                json.add("conditions", (JsonElement)conds);
            }
        }
    }
}

